function [cs_corrected_roi] = remove_circular_symmetry(pb_corrected_roi)

% Used to remove circular symmetry from the planar bias corrected image
%% input
% pb_corrected_roi : planar bias corrected region of interest

%% output
% cs_corrected_roi : circular symmetry corrected region of interest

ZdiffZ1=pb_corrected_roi;
[rr cc]=size(ZdiffZ1);
ZdiffZ2=ZdiffZ1;
% to check if any of the image dimension has an odd value
% Step 1 - Find which dimension of image is greater rr(i.e. row) or cc(i.e. column) or equal
 R=[];
 if rr > cc
     R=[1 0];
 elseif rr < cc
     R=[0 1];
 else
     R=[1 1];
 end
 ZdiffZ3=[];
% Step 2 - Check if the greater dimension has an odd value
if R(1)==1 & R(2)==0
    if floor(rr/2)~=rr/2
        ZdiffZ3=zeros(rr,cc+(rr-cc));
        ZdiffZ3(1:rr,1:cc)=ZdiffZ2;
    else
        ZdiffZ3=zeros(rr+1,cc+((rr+1)-cc));
        ZdiffZ3(1:rr,1:cc)=ZdiffZ2;
    end
elseif R(2)==1 & R(1)==0
    if floor(cc/2)~=cc/2
        ZdiffZ3=zeros((rr+(cc-rr)),cc);
        ZdiffZ3(1:rr,1:cc)=ZdiffZ2;
    else
       ZdiffZ3=zeros(rr+((cc+1)-rr),cc+1);
      ZdiffZ3(1:rr,1:cc)=ZdiffZ2;
    end
else
    if floor(cc/2)~=cc/2
        ZdiffZ3=ZdiffZ2;
    else
        ZdiffZ3=zeros(rr+1,cc+1);
      ZdiffZ3(1:rr,1:cc)=ZdiffZ2;
    end
end
ZdiffZ3(ZdiffZ3==0)=NaN;
% Step 3.1- If greater dimension has an odd value then pad the lesser dimension with zeros
% Step 3.2- If greater dimension has an even value make it odd by padding it with one layer of zeros and then pad the smaller dimension accordingly.

[rr21 cc21]=size(ZdiffZ3);
%ZdiffZ4=imresize(ZdiffZ3,0.3);
[rr1 cc1]=size(ZdiffZ3);
x_center= (rr1+1)/2;
y_center=(cc1+1)/2;
center=[x_center y_center];
basisDist=0;
distMat=zeros(rr1,cc1);
for i=1:rr1
    for j=1:cc1
       % develop a matrix based on distance values from centre
       pos=[i j];
       d= sqrt(sum((pos-center).^2));
       distMat(i,j)=d;
     %basisDist=sqrt(basisDist+1);
    end
end

uniqueD=unique(distMat);
imT=zeros(rr1,cc1); Q={};
% to find each circular symmetric basis based on function
beta=[];
for i=1:length(uniqueD)
    %imT=zeros(rr1,cc1);
    a=0;
    [rw cl]=find_logical(distMat==uniqueD(i));
    for j=1:length(rw)
        if  ~isnan(ZdiffZ3(rw(j),cl(j)))
            imT(rw(j),cl(j))=uniqueD(i);
            a=a+ZdiffZ3(rw(j),cl(j));
        end
    end
    if length(rw)~=0
     beta(i)=a/length(rw);
    else
        beta(i)=0;
    end
    %Q{i}=logical(imT);
end
[xxcv yycv]=find_logical(beta~=0);
bE=beta(1,yycv);
smoothed = f_loess(bE',0.75*length(bE));

% To make bE of the same size as the beta array
Beta_coeff=zeros(1,length(beta));
Beta_coeff(1,yycv)=bE;
Beta_coeff(Beta_coeff==0)=NaN;

Smooth_Beta=zeros(1,length(beta));
Smooth_Beta(1,yycv)=smoothed;
Sm_Beta = Smooth_Beta; %Used for reconstruction
Smooth_Beta(Smooth_Beta==0)=NaN;

figure;
plot(1:length(beta),Beta_coeff,'r.');
hold on;
plot(1:length(beta),Smooth_Beta,'b-','LineWidth',2);
xlim([0 length(beta)]);

Val=zeros(rr1,cc1);
%adding beta(k)*the circular radial basis function
for i=1:length(Sm_Beta)
    im=zeros(rr1,cc1);
   [xxx yyy vvv]=find(single(imT)==single(uniqueD(i)));
   if isempty(xxx)==0
       for j=1:length(xxx)
         im(xxx(j),yyy(j))=1;
       end
   end
   Val=Val+ Sm_Beta(i).*im;
end
Val(Val==0)=NaN;
cs_corrected_roi=ZdiffZ3-Val;% removing circular symmetry
cs_corrected_roi=cs_corrected_roi(1:rr,1:cc);


figure;
imagesc(ZdiffZ3);
figure;
imagesc(Val);
figure;
imagesc(cs_corrected_roi);
figure;
imshow(cs_corrected_roi,[]);
end
